(* ************************************************************ *)
(* ************************************************************ *)
(* univers-geo.ml :    univers geometrique pour ESIQMO          *)
(*								*)
(* Erika Valencia                  Creation 2 oct 97            *)
(* 				   Derniere modif : fev 98      *)
(* ************************************************************ *)
(*  ESQIMO 						        *)
(* ************************************************************ *)


#open "complex-lib";;
#open "set";;
#open "esq-kernel";;


(* ************************************************************ *)
	(* Univers geometrique *)
(* ************************************************************ *)

let e1 = creer_simplexe[1;5;6]
and e2 = creer_simplexe[2;5;6]
and e3 = creer_simplexe[3;5;6]
and e4 = creer_simplexe[1;4;6]
and e5 = creer_simplexe[2;4;6]
and e6 = creer_simplexe[3;4;6]
and e7 = creer_simplexe[1;5;7]
and e8 = creer_simplexe[2;5;7]
and e9 = creer_simplexe[3;5;7]
and e10 = creer_simplexe[1;4;7]
and e11 = creer_simplexe[2;4;7]
and e12 = creer_simplexe[3;4;7];;

let omega = creer_complexe[e1;e2;e3;e4;e5;e6;e7;e8;e9;e10;e11;e12];;

(* ************************************************************ *)

let nom_de =
	function [1;5;6] -> "e1"
	| [2;5;6] -> "e2"
	| [3;5;6] -> "e3"
	| [1;4;6] -> "e4"
	| [2;4;6] -> "e5"
	| [3;4;6] -> "e6"
	| [1;5;7] -> "e7"
	| [2;5;7] -> "e8"
	| [3;5;7] -> "e9"
	| [1;4;6] -> "e10"
	| [2;4;6] -> "e11"
	| [3;4;6] -> "e12"
	| _ -> "inconnu";;
