(* ************************************************************ *)
(* ************************************************************ *)
(* esq-kernel.ml : Resolution de tests de QI A:B::C:D avec	*)
(*		   representation des connaissances en CS       *)
(*								*)
(* Erika Valencia                  Creation 2 oct 97            *)
(* 				   Derniere modif : mai 98      *)
(* ************************************************************ *)
(* Principe et Algo:						*)
(* esq-kernel prend des simplexes ou listes de simplexes comme	*)
(* representation des figures A, B, C				*)
(* ces figures sont fournies a l'aide du fichier univers	*)
(* (par exemple univers-geo.ml)					*)
(* le principe de resolution suit les 4 etapes:			*)
(* trouver la relation de A a B					*)
(* trouver le domaine de C					*)
(* appliquer la transfo a C					*)
(* 								*)
(* trouver la relation de A a B:				*)
(*	cas simple (figures = 1 simplexe):			*)
(*	trouver q-chemin avec q max et longueur min entre	*)
(*	A et B. traduire ce chemin en deformation des proprietes*)
(* 	cas complexe (ens de simplexes):			*)
(*	trouver des appariements entre A et B, heuristiques	*)
(*      puis appliquer le casprecedent a chaque paire		*)
(* trouver domainde de C:					*)
(*	trouver chemin de A a C q max et long min, heurstiques	*)
(* appliquer a D:						*)
(*	selon la deformation des proprietes, heristiques	*)
(* ************************************************************ *)



(* ************************************************************ *)
	(* Les includes *)
(* ************************************************************ *)

#open "complex-lib";;
#open "sort";;
#open "set";;
#open "printf";;


(* ************************************************************ *)
(*	CAS SIMPLE -- CAS SIMPLE -- CAS SIMPLE                  *)
(* ************************************************************ *)

(* ************************************************************ *)
	(* Q chemins entre deux simplexes dans un complexe *)
(* ************************************************************ *)

	(* un chemin est une chaine, l'ensemble des chemins entre*)
	(* deux simplexes est represente par un set de chaines *)

let voir_chemins ch = map voir_chaine (elements ch);;

let rec chemins c l q s1 s2 = 
	(* avec dimension q et longueur de chemin l exactement *)
	if (l == 0) then 
		(if (compare_cplx s1 s2) 
		 then (add (cChaine([s1])) (empty(eq__compare)))
		 else (empty(eq__compare)))
	else ( let f j accu = union accu (chemins c (l-1) q s1 j ) 
		in let prefixe = fold f (voisins c q s2) (empty(eq__compare))
			in let g ch accu = add (add_chaine s2 ch) accu
				in fold g  prefixe (empty(eq__compare)));; 

let pour_court_chemin c q long s1 s2 chmax = 
	let chems = chemins c long q s1 s2 in
	(if ((voir_chemins(chems)) <> [])
        then (fold min_chaine (chems) (chmax))
	else cChaine[]);;
				
let court_chemin c q s1 s2 = 
		(* le plus court chemin *)
	let lmax = nb_sommets_cplx c
	and chmax = cChaine(elements c)
	in (	if (lmax > 6) 
		then (	let long = (lmax/2) 
			in pour_court_chemin c q long s1 s2 chmax)
		else (	let long = lmax
			in pour_court_chemin c q long s1 s2 chmax));;

(* court_chemin pas trop lent, large_chemin lent *)
(* gardons pour l'instant comme heuristique le plus court chemin seulement *)

let rec large_court_chemin c q s1 s2 = 
	let ch = court_chemin c (q+1) s1 s2 in
		(if (ch = cChaine[]) then court_chemin c q s1 s2 
		 else large_court_chemin c (q+1) s1 s2);;


let meilleur_chemin c s1 s2 = 
	(* reglage en dur de l'heuristique meilleur chemin *)

	(* large_court_chemin c 0 s1 s2*)
	court_chemin c 1 s1 s2;;



(* ************************************************************ *)
    (* Transformation elementaire correspondant a un chemin *)
(* ************************************************************ *)

let rec pour_pas_elem = 
	function [] -> []
		 | [x] -> [[x;x]]
		 | [x;y] -> [[x;y]]
		 | x::y::l -> add_list [x;y] (pour_pas_elem (y::l));;

let pas_elementaires (cChaine c) = pour_pas_elem c;;

let voir_pas_elem l = map voir_liste_splx l;;

let rec pour_inv_tr l1  = 
	function [] -> []
  	         | [x] -> if (mem_list x l1) 
			  then [x] else []
		 | x::l -> if (mem_list x l1) 
			   then [x]@(pour_inv_tr l1 l) else [];;

let inv_tr s1 s2 = 
	(* les sommets invariants dans un pas elementaire *)
	pour_inv_tr (sommets_splx s1) (sommets_splx s2);;

let rec pour_plus_tr l1 = 
	function [] -> []
		 | [x] -> if (not_mem_list x l1) then [x] else []
		 | x::l -> if (not_mem_list x l1) 
			   then [x]@(pour_plus_tr l1 l) 
			   else (pour_plus_tr l1 l) ;;

let plus_tr s1 s2 = 
	(* les sommets en plus dans un pas elementaire *)
	pour_plus_tr (sommets_splx s1) (sommets_splx s2);;

let moins_tr s1 s2 =
	(* les sommets en moins dans un pas elementaire *) 
	pour_plus_tr (sommets_splx s2) (sommets_splx s1);;



(* ************************************************************ *)
    (* Application d'une transformation elementaire *)
(* ************************************************************ *)

	(* premiere heuristique h1 *)
	(* on ajoute les sommets p, on enelve les sommets m *)

let rec pour_applique_h1 p m = 
	function [] -> p
		 | [x] -> if (mem_list x m) then p else x::p
		 | x::l -> if (mem_list x m) 
			   then (pour_applique_h1 p m l) 
			   else [x]@(pour_applique_h1 p m l);;

let applique_h1 s1 s2 s3 = 
	(* on enleve les ptes enlevees sur B, et on ajoute celles*)
	(* qui lui ont ete ajoutees *)
	let p = plus_tr s1 s2 
	and m = moins_tr s1 s2 in
		trie_list(pour_applique_h1 p m (elements s3));;

(* ************************************************************ *)

	(* deuxieme heuristique h2 *)
	(* on enleve les sommets m *)

let rec pour_applique_h2 m = 
	function [] -> []
		 | [x] -> if (mem_list x m) then [] else [x]
		 | x::l -> if (mem_list x m) 
			   then (pour_applique_h2 m l)
			   else [x]@(pour_applique_h2 m l);;

let applique_h2 s1 s2 s3 = 
	(* on enleve seulment les proprietes qui ont expressement*)
	(* ete enlevees sur B *)
	let m = moins_tr s1 s2 in
		trie_list (pour_applique_h2 m (elements s3));;



(* ************************************************************ *)		

	(* troisieme heuristique h3 *)
	(* tout devient s2 *)

let applique_h3 s1 s2 s3 = 
	(* qqsoit s1 et s3, la solution est s2 = transfo cste *)
	elements s2;;



(* ************************************************************ *)		

	(* quatrieme heuristique h4 *)
	(* si s3 = s1 alors s2, sinon s3 *)

let applique_h4 s1 s2 s3 = 
	if (compare_cplx s1 s3) then (elements s2) 
	else (elements s3);;



(* ************************************************************ *)		

	(* cinquieme heuristique h5 *)
	(* connaissance a priori sur nombre args et type *)
(* dans ce cas, cela depend du nombre et des arguments de l'univers
 * considere, cette information provient d'un fichier exterieur
 * de plus, cela revient a refaire toutes les strategies de
 * changement sur chacune des coordonnes, dans un univers des
 * valeurs possibles restreint dans chaque cas aux valeurs possibles
 * pour chaque variable *)


(* ************************************************************ *)		

let applique_h s l =
	(* reglage en dur du choix de l'heuristique *)
	if ( (list_length l > 2) or (list_length l < 2)) 
	then raise ErrorEsqimo
	else ( applique_h1 (list_select 1 l) (list_select 2 l) 
	                   (creer_simplexe s));;



(* ************************************************************ *)
	(* Resolution du test cas simple *)
(* ************************************************************ *)

let rec pour_resoud_simple s =
	function [] -> s
		 | [x] -> applique_h s x
		 | x::l -> applique_h (pour_resoud_simple s l) x;;

(* la sortie de la fct resoud rend un simplexe en prenant des 
 * simplexes en entree, cela est homogene meme si la visualisation 
 * est moins directe *)

let resoud_simple c s1 s2 s3 = 
	(* resolution cas simple: sans appariements *)
	let l = pas_elementaires(meilleur_chemin c s1 s2) in
		creer_simplexe (pour_resoud_simple (elements s3) l);;



(* ************************************************************ *)
(*	CAS COMPOSE -- CAS COMPOSE -- CAS COMPOSE               *)
(* ************************************************************ *)



(* ************************************************************ *)
	(* Appariement de figures                               *)
(* ************************************************************ *)

let rec apparie_eq f1 f2 = 
	(* appariement avec figures de longueur egale *)
	match (f1,f2) with
	([],[]) -> [[]]
	| ([x], []) -> [[]]
	| ([], [y]) -> [[]]
	| ([x],[y]) -> [[x;y]]
	| (x::l1,y::l2) -> [x;y]::(apparie_eq l1 l2)
	| _ -> raise ErrorEsqimo;;

let rec apparie_sur_un u =
	function [] -> [[]]
	| [x] -> [[x;u]]
	| x::l -> [x;u]::(apparie_sur_un u l);;
	
let rec apparie_de_un u =
	function [] -> [[]]
	| [x] -> [[u;x]]
	| x::l -> [u;x]::(apparie_de_un u l);;
	

let rec apparie_sup f1 f2 = 
	(* appariement avec longueur f1 plus grande *)
	let i = list_length f2 in
		let eq = sous_list i f1
		and sup = sous_fin_list i f1 in
	(apparie_eq eq f2)@(apparie_sur_un (fin f2) sup);;

let rec apparie_inf f1 f2 = 
	(* appariement avec longueur f1 plus grande *)
	let i = list_length f1 in
		let eq = sous_list i f2
		and sup = sous_fin_list i f2 in
	(apparie_eq f1 eq)@(apparie_de_un (fin f1) sup);;

let apparie f1 f2 = 
	if ((list_length f1) == (list_length f2)) 
	then apparie_eq f1 f2
	else ( 	if ((list_length f1) > (list_length f2))
		then apparie_sup f1 f2
		else apparie_inf f1 f2 );;

let traite_cas_compose f1 f2 =
	if ((f1 <> []) & (f2 <> []) )
	then apparie f1 f2
	else raise ErrorEsqimo;;



(* ************************************************************ *)
    (* Application d'une transformation d'appariements *)
(* ************************************************************ *)

let rec trouve_app_de x = 
	function [] -> raise ErrorEsqimo
	| [a;b]::l -> if (a == x) then b else trouve_app_de x l
	| _ -> raise ErrorEsqimo;;

let traite_un_app c ap2 l =
	let s1 = list_select 1 l
	and s2 = list_select 2 l
	in (let  s3 = (trouve_app_de s1 ap2)
	    in resoud_simple c s1 s2 s3);; 	

let applique_app c ap1 ap2 =
	map (traite_un_app c ap2) ap1;;



(* ************************************************************ *)
	(* Resolution du test cas compose *)
(* ************************************************************ *)


let resoud_compose c f1 f2 f3 =
	(* resolution avec appariements *)
	let lab = traite_cas_compose f1 f2
	and lac = traite_cas_compose f1 f3 in
		applique_app c lab lac;;

(* ************************************************************ *)



















