(* ************************************************************ *)
(* ************************************************************ *)
(* complex-lib.ml : Bibliotheque de creation et manip de CS     *)
(*								*)
(* Erika Valencia                  Creation 2 oct 97            *)
(* 				   Derniere modif : mai 98      *)
(* ************************************************************ *)
(* ************************************************************ *)



(* ************************************************************ *)
	(* Les includes *)
(* ************************************************************ *)

#open "sort";;
#open "set";;
#open "printf";;

exception ErrorEsqimo;;

(* ************************************************************ *)
	(* Operations sur les listes *)
(* ************************************************************ *)
	
let rec concatene l1 l2 =          
	(*concatene les listes l1 et l2 *)
        match l1 with
        [] -> l2
        | x::reste -> x::concatene reste l2;;

	
let rec fin = function []   -> raise ErrorEsqimo
	(* dernier element de la liste *)
 	                | [x]  -> x
 			| _::l -> fin l;;
 
let rec select p = 
	(* selectionne la liste des elements d'une liste qui *)
	(* satisfont au predicat p *)
	function []   -> []
 	         | x::l -> if (p x) then x::(select p l) 
			   else select p l;;
 
let rec list_select i l = 
	(* selectionne le ieme element de la liste *)
	if ((list_length l >= i) & (i > 1))
        then (list_select (i-1) (tl(l)))
        else hd(l);;

let rec sous_list i l =
	(* selectionne la sous-liste jusqu'au rang i inclus ds l *)
	if ((list_length l >= i ) & (i > 0))
	then (sous_list (i-1) l)@[(list_select i l)]
	else [];;

let rec pour_sous_fin_list i =
	function [x] -> []
		 | x::l1 -> (if (i==1) then l1
			     else pour_sous_fin_list (i-1) l1);;

let sous_fin_list i l =
	if ((list_length l) >= i)
	then (if (i > 0)
	      then pour_sous_fin_list i l 
	      else l )
	else raise ErrorEsqimo
	;;

let add_list a = 
	(* ajoute l'element en tete de la liste *)
	function [] -> [a]
	 	 | [x] -> [a;x]
	 	 | x::l -> a::x::l;; 

	(* car fonction "mem" teste uniquement l'inclusion sur *)
	(* les ensembles a cause du include "set" *)
let rec mem_list x  = 
	function [] -> false
	         | [y] -> (if (x == y) then true else false)
    	         | y::l -> (if (x == y) then true else (mem_list x l));;
 
let not_mem_list x l = 
	if (mem_list x l) then false
	else true;;

let rec list_to_ens = 
	(* transforme une liste en un ensemble *)
	(* supprime les duppliques *)
	function [] -> empty(eq__compare)
		 | x::l -> add x (list_to_ens l );;

let trie_list l = 
	(* trie une liste en supprimant les duppliques *)
	elements (list_to_ens l);;
	


(* ************************************************************ *)
	(* Creation et operations sur les simplexes *)
(* ************************************************************ *)

	(* une simplexe est un ensemble *)
	
let rec creer_simplexe = function
        [] -> (empty(eq__compare))
        | x::l -> add x (creer_simplexe l);;

let ajoute_simplexe s l = 
	creer_simplexe (concatene(elements s) l);;

let enleve_simplexe s l = 
	remove l s;;

let dim l = list_length(elements(l)) - 1;;
	
let sommets_splx s  = elements s;;

let nb_sommets_splx s = list_length (sommets_splx s);;

let dans_splx x y = 
	(* teste si un simplexe est contenu dans un autre *)
	 (equal (inter x y) x);;

let trie_simplexe s = 
	(* trier le simplexes *)
	creer_simplexe (sort (le_int)(elements s));;
	
let voir_liste_splx l = map elements l;;

let voir_appariements l = map voir_liste_splx l;;



(* ************************************************************ *)
	(* Creation et operations sur les complexes *)
(* ************************************************************ *)

	(* un complexe est un ensemble de simplexes maximaux*)
	(* c'est donc un ensemble d'ensembles *)
	
let trie_liste_splx l =
	sort (fun s1 s2 -> (dim s1 < dim s2)) l;;

let dans_cplx x m = 
	(* teste si un simplexe est contenu dans un cplx *)
	 exists (dans_splx x) (elements m);;

let rec pour_creer_complexe = function
	  [] -> empty(eq__compare)
	| x::l -> let m = pour_creer_complexe l 
		  in (if dans_cplx x m then m else add x m);;
		
let rec creer_complexe l = 
	let sl = trie_liste_splx l 
	in pour_creer_complexe sl;;

let elements_cplx x = map elements (elements x);;

let sommets_cplx c = map elements (elements c);;
	
let nb_sommets_cplx c = list_length (sommets_cplx c);;

let compare_cplx c1 c2 = 0 == (set__compare c1 c2) ;;


	
(* ************************************************************ *)
	(* Operations sur les chaines *)
(* ************************************************************ *)
	
	(* une chaine est une liste de simplexes (d'ens) *)

let fin_chaine =
	(* dernier element de la chaine *) 
	function (cChaine l) -> fin l;;

let pour_add_chaine x = function cChaine l -> cChaine (l@[x]);;
	
let add_chaine x ch =
	(* si un element n'est pas deja present en bout de chaine*)
	let bout = fin_chaine(ch)
	in (if (not(compare_cplx x bout)) then (pour_add_chaine x ch)
	else ch);;

let chaine_length  (cChaine c) = list_length (c);;

let dans_chaine (cChaine c) = function x -> x mem c;;

let min_chaine (cChaine ch1) (cChaine ch2) = 
	if ((list_length ch1) <= (list_length ch2)) 
	then (cChaine ch1) else (cChaine ch2);;

let voir_chaine (cChaine c) = 
	(* explose les elements (simplexes) de la chaine *)
	map elements c;; 



(* ************************************************************ *)
	(* Q connectivite entre deux simplexes *)
(* ************************************************************ *)

let connectivite q x y = 
 	(* renvoie soit ensemble vide, soit l'intersection si >q *)
        let commun = inter x y 
        in if (list_length (elements commun) > q ) then commun
        else  empty(eq__compare);;


let rec  pour_voisins q s e = 
	(* qVoisins d'un splx s dans un cplx c avec le degre q *)
	function [] ->  e
                 | t::l1 -> if (dim (inter s t) < q)
                            then pour_voisins q s e l1
                            else pour_voisins q s (add t e) l1;;
		
let  voisins c q s = 
	pour_voisins q  s (empty(eq__compare)) (elements c);;

let rec  pour_voisins_strict q s e = 
	function [] ->  e
                 | t::l1 -> if ((dim (inter s t) < q) 
				& ((eq__compare s t)==1))
                            then pour_voisins_strict q s e l1
                         else pour_voisins_strict q s (add t e) l1;;
		
let voisins_strict c q s =  
	pour_voisins_strict q  s (empty(eq__compare)) (elements c);;


(* ************************************************************ *)


















